import { Injectable } from '@angular/core';
import {HttpClient} from '@angular/common/http';
import {Observable} from 'rxjs/Observable';
import {JsonConvert} from 'json2typescript';
import {BehaviorSubject} from 'rxjs/BehaviorSubject';
import {map} from 'rxjs/operators';

@Injectable()
export abstract class RestService<T> {
  protected _data: BehaviorSubject<T[]> = new BehaviorSubject(undefined);
  readonly data: Observable<T[]> = this._data.asObservable();
  protected _meta: BehaviorSubject<any> = new BehaviorSubject(undefined);
  readonly meta: Observable<any> = this._meta.asObservable();

  protected jsonConverter: JsonConvert = new JsonConvert();

  constructor(protected http: HttpClient,
              protected endPointAddress: string,
              protected genericInstance: { new(): T }) { }

  get(): Observable<T[]> {
    return this.http
      .get<T[]>(this.endPointAddress)
      .pipe(
        map((response: any) => {
          const objects = this.jsonConverter.deserializeArray(JSON.parse(response.data), this.genericInstance);
          this._data.next(objects);
          this._meta.next(JSON.parse(response.meta));
          return objects;
        })
      );
  }
}
