import {Component, Input, OnInit} from '@angular/core';
import {CryptoService} from '../../services/crypto.service';
import {Coin} from '../../models/coin';

@Component({
  selector: 'kro-crypto-list',
  templateUrl: './crypto-list.component.html',
  styleUrls: ['./crypto-list.component.scss']
})
export class CryptoListComponent implements OnInit {
  @Input()
  limit: number = Infinity;

  @Input('full')
  isFullInfo: boolean = true;

  coins: Coin[] = undefined;
  header: string = undefined;

  constructor(private cryptoService: CryptoService) { }

  ngOnInit() {
    this.cryptoService.get().subscribe(data => {
      this.coins = data;
      if (!this.isFullInfo) {
        this.coins = this.coins.slice(0, this.limit);
      }
    });
    this.cryptoService.meta.subscribe(header => {
      this.header = header;
    });
  }
}
