import {Component, Input, OnInit} from '@angular/core';
import {CurrencyService} from '../../services/currency.service';
import {Currency} from '../../models/currency';

@Component({
  selector: 'kro-currency-list',
  templateUrl: './currency-list.component.html',
  styleUrls: ['./currency-list.component.scss']
})
export class CurrencyListComponent implements OnInit {
  @Input()
  limit: number = Infinity;

  @Input('full')
  isFullInfo: boolean = true;

  currencies: Currency[] = undefined;
  header: string = undefined;

  constructor(private currencyService: CurrencyService) { }

  ngOnInit() {
    this.currencyService.get().subscribe(data => {
      this.currencies = data;
      if (!this.isFullInfo) {
        this.currencies = this.currencies.slice(0, this.limit);
      }
    });
    this.currencyService.meta.subscribe(header => {
      this.header = header;
    });
  }

}
